#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.

import os
import shutil
import time
import traceback
from utils import resource_util
from cbb.frame.util import file_operate_util

OEM_DM_CLIENT_NAME = "Distributed-Storage_devicemanager-client.zip"


def execute(context):
    oem_path = context.get('oemPath')
    original_pkg_path = context.get('originalPkgPath')
    create_path = context.get('createPath')
    logger = context.get('logger')

    work_dir = os.getcwd()
    now_time = str(int(time.time()))
    temp_dir = work_dir + os.sep + 'temporary' + now_time
    file_operate_util.make_dir(temp_dir)
    destination_oem_path = temp_dir + os.sep + "oem"
    file_operate_util.make_dir(destination_oem_path)
    dest_oem_product_path = create_path + os.sep + OEM_DM_CLIENT_NAME
    try:
        file_operate_util.decompress_zip(original_pkg_path, temp_dir)
        shutil.copy(oem_path, destination_oem_path)
        file_operate_util.decompress_tgz(oem_path, destination_oem_path)
        file_operate_util.compress_zip(temp_dir, dest_oem_product_path)
        return True, ""
    except Exception:
        logger.error(str(traceback.format_exc()))
        return False, resource_util.create_msg(
            "make.oem.package.error", context.get('lan'))
    finally:
        file_operate_util.clean_dir(temp_dir)
